/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.server.util.ExpandJar;

public class ClassLoaderUtil {
    private static final Logger LOGGER = Grizzly.logger(ClassLoaderUtil.class);

    public static ClassLoader createClassloader(File libDir, ClassLoader cl) throws IOException {
        URLClassLoader urlClassloader = null;
        if (libDir.exists() && libDir.isDirectory()) {
            String[] jars = libDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar") || name.endsWith(".zip");
                }
            });
            URL[] urls = new URL[jars.length];
            for (int i = 0; i < jars.length; ++i) {
                String path2 = new File(libDir.getName() + File.separator + jars[i]).getCanonicalFile().toURI().toURL().toString();
                urls[i] = new URL(path2);
            }
            urlClassloader = ClassLoaderUtil.createClassLoaderWithSecCheck(urls, cl);
        }
        return urlClassloader;
    }

    public static URLClassLoader createURLClassLoader(String dirPath) throws IOException {
        URL[] urls;
        String path2;
        URL classesURL;
        URL appRoot;
        String separator;
        if (!(dirPath.endsWith(File.separator) || dirPath.endsWith(".war") || dirPath.endsWith(".jar"))) {
            dirPath = dirPath + File.separator;
        }
        String string2 = separator = System.getProperty("os.name").toLowerCase().startsWith("win") ? "/" : "//";
        if (dirPath != null && (dirPath.endsWith(".war") || dirPath.endsWith(".jar"))) {
            File file = new File(dirPath);
            appRoot = new URL("jar:file:" + separator + file.getCanonicalPath().replace('\\', '/') + "!/");
            classesURL = new URL("jar:file:" + separator + file.getCanonicalPath().replace('\\', '/') + "!/WEB-INF/classes/");
            path2 = ExpandJar.expand(appRoot);
        } else {
            path2 = dirPath;
            classesURL = new URL("file://" + path2 + "WEB-INF/classes/");
            appRoot = new URL("file://" + path2);
        }
        String absolutePath = new File(path2).getAbsolutePath();
        File libFiles = new File(absolutePath + File.separator + "WEB-INF" + File.separator + "lib");
        int arraySize = 4;
        if (libFiles.exists() && libFiles.isDirectory()) {
            urls = new URL[libFiles.listFiles().length + arraySize];
            for (int i = 0; i < libFiles.listFiles().length; ++i) {
                urls[i] = new URL("jar:file:" + separator + libFiles.listFiles()[i].toString().replace('\\', '/') + "!/");
            }
        } else {
            urls = new URL[arraySize];
        }
        urls[urls.length - 1] = classesURL;
        urls[urls.length - 2] = appRoot;
        urls[urls.length - 3] = new URL("file://" + path2 + "/WEB-INF/classes/");
        urls[urls.length - 4] = new URL("file://" + path2);
        return ClassLoaderUtil.createClassLoaderWithSecCheck(urls, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URLClassLoader createURLClassLoader(String location, ClassLoader parent) throws IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(parent);
        try {
            URLClassLoader uRLClassLoader = ClassLoaderUtil.createURLClassLoader(location);
            return uRLClassLoader;
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    public static Object load(String clazzName) {
        return ClassLoaderUtil.load(clazzName, Thread.currentThread().getContextClassLoader());
    }

    public static Object load(String clazzName, ClassLoader classLoader) {
        try {
            Class<?> className = Class.forName(clazzName, true, classLoader);
            return className.newInstance();
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Unable to load class " + clazzName, t);
            return null;
        }
    }

    private static URLClassLoader createClassLoaderWithSecCheck(final URL[] urls, final ClassLoader parent) {
        if (System.getSecurityManager() == null) {
            return new URLClassLoader(urls, parent);
        }
        return AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls, parent);
            }
        });
    }
}

